#include "GetPoint.js"

function DoEllipseCorner()
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return;

	ui.beginUIUpdate();
	ui.hideUI( 'FirstCornerPrompt' );
	ui.showUI( 'SecondCornerPrompt' );
	ui.showUI( 'WidthHeight' );
	ui.endUIUpdate();

	var ellipsefactory = moi.command.createFactory( 'ellipsecorner' );

	ellipsefactory.setInput( 0, pointpicker.ptframe );

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, true );
	pointpicker.disableVerticalStraightSnap = true;
	pointpicker.disableStraightSnapAngle( 0 );
	pointpicker.disableStraightSnapAngle( 90 );
	pointpicker.disableStraightSnapAngle( 180 );
	pointpicker.disableStraightSnapAngle( 270 );
	pointpicker.disableStraightSnapAngle( 360 );
	
	pointpicker.bindResultPt( ellipsefactory.getInput(1) );
	pointpicker.bindResultOrientation( ellipsefactory.getInput(0) );
	pointpicker.bindFunc( ui.commandUI.OnPoint );

	var HaveWidth = false, HaveHeight = false;
	
	ui.commandUI.g_BasePt = pointpicker.pt;

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
		{
			break;
		}
		else if ( pointpicker.event == 'width' )
		{
			ellipsefactory.setInput( 2, ui.commandUI.width.value );
			ellipsefactory.update();
			
			HaveWidth = true;
			ui.commandUI.g_HaveWidth = true;
		}
		else if ( pointpicker.event == 'height' )
		{
			ellipsefactory.setInput( 3, ui.commandUI.height.value );
			ellipsefactory.update();
			
			HaveHeight = true;
			ui.commandUI.g_HaveHeight = true;
		}

		if ( HaveWidth && HaveHeight )
			break;
	}

	ellipsefactory.commit();
}

DoEllipseCorner();
